package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMaintenanceWindowRequest(windowId: MaintenanceWindowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest = {
    import DeleteMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.DeleteMaintenanceWindowRequest.wrap(buildAwsValue())
}
object DeleteMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteMaintenanceWindowRequest =
      zio.aws.ssm.model.DeleteMaintenanceWindowRequest(windowId)
    def windowId: MaintenanceWindowId
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.DeleteMaintenanceWindowRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest
  ): zio.aws.ssm.model.DeleteMaintenanceWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
