package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInventoryResponse(
    entities: Optional[Iterable[zio.aws.ssm.model.InventoryResultEntity]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetInventoryResponse = {
    import GetInventoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetInventoryResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetInventoryResponse.ReadOnly =
    zio.aws.ssm.model.GetInventoryResponse.wrap(buildAwsValue())
}
object GetInventoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetInventoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetInventoryResponse =
      zio.aws.ssm.model.GetInventoryResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entities
        : Optional[List[zio.aws.ssm.model.InventoryResultEntity.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryResultEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetInventoryResponse
  ) extends zio.aws.ssm.model.GetInventoryResponse.ReadOnly {
    override val entities
        : Optional[List[zio.aws.ssm.model.InventoryResultEntity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryResultEntity.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetInventoryResponse
  ): zio.aws.ssm.model.GetInventoryResponse.ReadOnly = new Wrapper(impl)
}
