package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationVersion,
  AssociationId,
  InstanceId,
  DocumentARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAssociationRequest(
    name: Optional[DocumentARN] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    associationId: Optional[AssociationId] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest = {
    import DescribeAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeAssociationRequest.ReadOnly =
    zio.aws.ssm.model.DescribeAssociationRequest.wrap(buildAwsValue())
}
object DescribeAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAssociationRequest =
      zio.aws.ssm.model.DescribeAssociationRequest(
        name.map(value => value),
        instanceId.map(value => value),
        associationId.map(value => value),
        associationVersion.map(value => value)
      )
    def name: Optional[DocumentARN]
    def instanceId: Optional[InstanceId]
    def associationId: Optional[AssociationId]
    def associationVersion: Optional[AssociationVersion]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest
  ) extends zio.aws.ssm.model.DescribeAssociationRequest.ReadOnly {
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest
  ): zio.aws.ssm.model.DescribeAssociationRequest.ReadOnly = new Wrapper(impl)
}
