package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait CommandInvocationStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.CommandInvocationStatus
}
object CommandInvocationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.CommandInvocationStatus
  ): zio.aws.ssm.model.CommandInvocationStatus = value match {
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.DELAYED =>
      val r = Delayed
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.CANCELLING =>
      val r = Cancelling
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.PENDING
  }
  case object InProgress extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.IN_PROGRESS
  }
  case object Delayed extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.DELAYED
  }
  case object Success extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.SUCCESS
  }
  case object Cancelled extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.CANCELLED
  }
  case object TimedOut extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.TIMED_OUT
  }
  case object Failed extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.FAILED
  }
  case object Cancelling extends zio.aws.ssm.model.CommandInvocationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CommandInvocationStatus =
      software.amazon.awssdk.services.ssm.model.CommandInvocationStatus.CANCELLING
  }
}
