package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  IamRole,
  RegistrationsCount,
  RegistrationLimit,
  ActivationId,
  DefaultInstanceName,
  ExpirationDate,
  CreatedDate,
  ActivationDescription
}
import scala.jdk.CollectionConverters._
final case class Activation(
    activationId: Optional[ActivationId] = Optional.Absent,
    description: Optional[ActivationDescription] = Optional.Absent,
    defaultInstanceName: Optional[DefaultInstanceName] = Optional.Absent,
    iamRole: Optional[IamRole] = Optional.Absent,
    registrationLimit: Optional[RegistrationLimit] = Optional.Absent,
    registrationsCount: Optional[RegistrationsCount] = Optional.Absent,
    expirationDate: Optional[ExpirationDate] = Optional.Absent,
    expired: Optional[Boolean] = Optional.Absent,
    createdDate: Optional[CreatedDate] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Activation = {
    import Activation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Activation
      .builder()
      .optionallyWith(
        activationId.map(value => ActivationId.unwrap(value): java.lang.String)
      )(_.activationId)
      .optionallyWith(
        description.map(value =>
          ActivationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        defaultInstanceName.map(value =>
          DefaultInstanceName.unwrap(value): java.lang.String
        )
      )(_.defaultInstanceName)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        registrationLimit.map(value => RegistrationLimit.unwrap(value): Integer)
      )(_.registrationLimit)
      .optionallyWith(
        registrationsCount.map(value =>
          RegistrationsCount.unwrap(value): Integer
        )
      )(_.registrationsCount)
      .optionallyWith(
        expirationDate.map(value => ExpirationDate.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(expired.map(value => value: java.lang.Boolean))(_.expired)
      .optionallyWith(
        createdDate.map(value => CreatedDate.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Activation.ReadOnly =
    zio.aws.ssm.model.Activation.wrap(buildAwsValue())
}
object Activation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Activation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Activation = zio.aws.ssm.model.Activation(
      activationId.map(value => value),
      description.map(value => value),
      defaultInstanceName.map(value => value),
      iamRole.map(value => value),
      registrationLimit.map(value => value),
      registrationsCount.map(value => value),
      expirationDate.map(value => value),
      expired.map(value => value),
      createdDate.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def activationId: Optional[ActivationId]
    def description: Optional[ActivationDescription]
    def defaultInstanceName: Optional[DefaultInstanceName]
    def iamRole: Optional[IamRole]
    def registrationLimit: Optional[RegistrationLimit]
    def registrationsCount: Optional[RegistrationsCount]
    def expirationDate: Optional[ExpirationDate]
    def expired: Optional[Boolean]
    def createdDate: Optional[CreatedDate]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getActivationId: ZIO[Any, AwsError, ActivationId] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getDescription: ZIO[Any, AwsError, ActivationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultInstanceName: ZIO[Any, AwsError, DefaultInstanceName] =
      AwsError.unwrapOptionField("defaultInstanceName", defaultInstanceName)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRegistrationLimit: ZIO[Any, AwsError, RegistrationLimit] =
      AwsError.unwrapOptionField("registrationLimit", registrationLimit)
    def getRegistrationsCount: ZIO[Any, AwsError, RegistrationsCount] =
      AwsError.unwrapOptionField("registrationsCount", registrationsCount)
    def getExpirationDate: ZIO[Any, AwsError, ExpirationDate] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getExpired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("expired", expired)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDate] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Activation
  ) extends zio.aws.ssm.model.Activation.ReadOnly {
    override val activationId: Optional[ActivationId] = zio.aws.core.internal
      .optionalFromNullable(impl.activationId())
      .map(value => zio.aws.ssm.model.primitives.ActivationId(value))
    override val description: Optional[ActivationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.ActivationDescription(value))
    override val defaultInstanceName: Optional[DefaultInstanceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultInstanceName())
        .map(value => zio.aws.ssm.model.primitives.DefaultInstanceName(value))
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.ssm.model.primitives.IamRole(value))
    override val registrationLimit: Optional[RegistrationLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationLimit())
        .map(value => zio.aws.ssm.model.primitives.RegistrationLimit(value))
    override val registrationsCount: Optional[RegistrationsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationsCount())
        .map(value => zio.aws.ssm.model.primitives.RegistrationsCount(value))
    override val expirationDate: Optional[ExpirationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationDate())
        .map(value => zio.aws.ssm.model.primitives.ExpirationDate(value))
    override val expired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.expired())
      .map(value => value: Boolean)
    override val createdDate: Optional[CreatedDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.CreatedDate(value))
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Activation
  ): zio.aws.ssm.model.Activation.ReadOnly = new Wrapper(impl)
}
