package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  AssociationId,
  ApplyOnlyAtCronInterval,
  TargetMapValue,
  ParameterName,
  ParameterValue,
  TargetMapKey,
  DocumentARN,
  ScheduleExpression,
  AssociationName,
  DocumentVersion,
  ScheduleOffset,
  AssociationVersion,
  CalendarNameOrARN,
  AutomationTargetParameterName,
  MaxConcurrency,
  MaxErrors
}
import scala.jdk.CollectionConverters._
final case class UpdateAssociationRequest(
    associationId: AssociationId,
    parameters: Optional[Map[ParameterName, Iterable[ParameterValue]]] =
      Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    outputLocation: Optional[
      zio.aws.ssm.model.InstanceAssociationOutputLocation
    ] = Optional.Absent,
    name: Optional[DocumentARN] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    associationName: Optional[AssociationName] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent,
    automationTargetParameterName: Optional[AutomationTargetParameterName] =
      Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    complianceSeverity: Optional[
      zio.aws.ssm.model.AssociationComplianceSeverity
    ] = Optional.Absent,
    syncCompliance: Optional[zio.aws.ssm.model.AssociationSyncCompliance] =
      Optional.Absent,
    applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval] =
      Optional.Absent,
    calendarNames: Optional[Iterable[CalendarNameOrARN]] = Optional.Absent,
    targetLocations: Optional[Iterable[zio.aws.ssm.model.TargetLocation]] =
      Optional.Absent,
    scheduleOffset: Optional[ScheduleOffset] = Optional.Absent,
    targetMaps: Optional[
      Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]
    ] = Optional.Absent,
    alarmConfiguration: Optional[zio.aws.ssm.model.AlarmConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest = {
    import UpdateAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
      .builder()
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        automationTargetParameterName.map(value =>
          AutomationTargetParameterName.unwrap(value): java.lang.String
        )
      )(_.automationTargetParameterName)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(complianceSeverity.map(value => value.unwrap))(
        _.complianceSeverity
      )
      .optionallyWith(syncCompliance.map(value => value.unwrap))(
        _.syncCompliance
      )
      .optionallyWith(
        applyOnlyAtCronInterval.map(value =>
          ApplyOnlyAtCronInterval.unwrap(value): java.lang.Boolean
        )
      )(_.applyOnlyAtCronInterval)
      .optionallyWith(
        calendarNames.map(value =>
          value.map { item =>
            CalendarNameOrARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.calendarNames)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .optionallyWith(
        scheduleOffset.map(value => ScheduleOffset.unwrap(value): Integer)
      )(_.scheduleOffset)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(alarmConfiguration.map(value => value.buildAwsValue()))(
        _.alarmConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateAssociationRequest.ReadOnly =
    zio.aws.ssm.model.UpdateAssociationRequest.wrap(buildAwsValue())
}
object UpdateAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateAssociationRequest =
      zio.aws.ssm.model.UpdateAssociationRequest(
        associationId,
        parameters.map(value => value),
        documentVersion.map(value => value),
        scheduleExpression.map(value => value),
        outputLocation.map(value => value.asEditable),
        name.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        associationName.map(value => value),
        associationVersion.map(value => value),
        automationTargetParameterName.map(value => value),
        maxErrors.map(value => value),
        maxConcurrency.map(value => value),
        complianceSeverity.map(value => value),
        syncCompliance.map(value => value),
        applyOnlyAtCronInterval.map(value => value),
        calendarNames.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduleOffset.map(value => value),
        targetMaps.map(value => value),
        alarmConfiguration.map(value => value.asEditable)
      )
    def associationId: AssociationId
    def parameters: Optional[Map[ParameterName, List[ParameterValue]]]
    def documentVersion: Optional[DocumentVersion]
    def scheduleExpression: Optional[ScheduleExpression]
    def outputLocation
        : Optional[zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly]
    def name: Optional[DocumentARN]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def associationName: Optional[AssociationName]
    def associationVersion: Optional[AssociationVersion]
    def automationTargetParameterName: Optional[AutomationTargetParameterName]
    def maxErrors: Optional[MaxErrors]
    def maxConcurrency: Optional[MaxConcurrency]
    def complianceSeverity
        : Optional[zio.aws.ssm.model.AssociationComplianceSeverity]
    def syncCompliance: Optional[zio.aws.ssm.model.AssociationSyncCompliance]
    def applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval]
    def calendarNames: Optional[List[CalendarNameOrARN]]
    def targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def scheduleOffset: Optional[ScheduleOffset]
    def targetMaps: Optional[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def alarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly]
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getOutputLocation: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getAutomationTargetParameterName
        : ZIO[Any, AwsError, AutomationTargetParameterName] =
      AwsError.unwrapOptionField(
        "automationTargetParameterName",
        automationTargetParameterName
      )
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getComplianceSeverity
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationComplianceSeverity] =
      AwsError.unwrapOptionField("complianceSeverity", complianceSeverity)
    def getSyncCompliance
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationSyncCompliance] =
      AwsError.unwrapOptionField("syncCompliance", syncCompliance)
    def getApplyOnlyAtCronInterval
        : ZIO[Any, AwsError, ApplyOnlyAtCronInterval] = AwsError
      .unwrapOptionField("applyOnlyAtCronInterval", applyOnlyAtCronInterval)
    def getCalendarNames: ZIO[Any, AwsError, List[CalendarNameOrARN]] =
      AwsError.unwrapOptionField("calendarNames", calendarNames)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
    def getScheduleOffset: ZIO[Any, AwsError, ScheduleOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getAlarmConfiguration
        : ZIO[Any, AwsError, zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("alarmConfiguration", alarmConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
  ) extends zio.aws.ssm.model.UpdateAssociationRequest.ReadOnly {
    override val associationId: AssociationId =
      zio.aws.ssm.model.primitives.AssociationId(impl.associationId())
    override val parameters
        : Optional[Map[ParameterName, List[ParameterValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value => zio.aws.ssm.model.primitives.ScheduleExpression(value))
    override val outputLocation: Optional[
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputLocation())
      .map(value =>
        zio.aws.ssm.model.InstanceAssociationOutputLocation.wrap(value)
      )
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val associationName: Optional[AssociationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationName())
        .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val automationTargetParameterName
        : Optional[AutomationTargetParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.automationTargetParameterName())
      .map(value =>
        zio.aws.ssm.model.primitives.AutomationTargetParameterName(value)
      )
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val complianceSeverity
        : Optional[zio.aws.ssm.model.AssociationComplianceSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSeverity())
        .map(value =>
          zio.aws.ssm.model.AssociationComplianceSeverity.wrap(value)
        )
    override val syncCompliance
        : Optional[zio.aws.ssm.model.AssociationSyncCompliance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncCompliance())
        .map(value => zio.aws.ssm.model.AssociationSyncCompliance.wrap(value))
    override val applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyOnlyAtCronInterval())
        .map(value =>
          zio.aws.ssm.model.primitives.ApplyOnlyAtCronInterval(value)
        )
    override val calendarNames: Optional[List[CalendarNameOrARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calendarNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.CalendarNameOrARN(item)
          }.toList
        )
    override val targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.TargetLocation.wrap(item)
          }.toList
        )
    override val scheduleOffset: Optional[ScheduleOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleOffset())
        .map(value => zio.aws.ssm.model.primitives.ScheduleOffset(value))
    override val targetMaps
        : Optional[List[Map[TargetMapKey, List[TargetMapValue]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMaps())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives
                  .TargetMapKey(key) -> value.asScala.map { item =>
                  zio.aws.ssm.model.primitives.TargetMapValue(item)
                }.toList
              })
              .toMap
          }.toList
        )
    override val alarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfiguration())
        .map(value => zio.aws.ssm.model.AlarmConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest
  ): zio.aws.ssm.model.UpdateAssociationRequest.ReadOnly = new Wrapper(impl)
}
