package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait StopType {
  def unwrap: software.amazon.awssdk.services.ssm.model.StopType
}
object StopType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.StopType
  ): zio.aws.ssm.model.StopType = value match {
    case software.amazon.awssdk.services.ssm.model.StopType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.StopType.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.ssm.model.StopType.CANCEL =>
      val r = Cancel
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.StopType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.StopType =
      software.amazon.awssdk.services.ssm.model.StopType.UNKNOWN_TO_SDK_VERSION
  }
  case object Complete extends zio.aws.ssm.model.StopType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.StopType =
      software.amazon.awssdk.services.ssm.model.StopType.COMPLETE
  }
  case object Cancel extends zio.aws.ssm.model.StopType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.StopType =
      software.amazon.awssdk.services.ssm.model.StopType.CANCEL
  }
}
