package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait SessionState {
  def unwrap: software.amazon.awssdk.services.ssm.model.SessionState
}
object SessionState {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.SessionState
  ): zio.aws.ssm.model.SessionState = value match {
    case software.amazon.awssdk.services.ssm.model.SessionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.SessionState.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.ssm.model.SessionState.HISTORY =>
      val r = History
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionState =
      software.amazon.awssdk.services.ssm.model.SessionState.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.ssm.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionState =
      software.amazon.awssdk.services.ssm.model.SessionState.ACTIVE
  }
  case object History extends zio.aws.ssm.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.SessionState =
      software.amazon.awssdk.services.ssm.model.SessionState.HISTORY
  }
}
