package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowTargetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTargetWithMaintenanceWindowResponse(
    windowTargetId: Optional[MaintenanceWindowTargetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse = {
    import RegisterTargetWithMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowTargetId.map(value =>
          MaintenanceWindowTargetId.unwrap(value): java.lang.String
        )
      )(_.windowTargetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse
      .wrap(buildAwsValue())
}
object RegisterTargetWithMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse =
      zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse(
        windowTargetId.map(value => value)
      )
    def windowTargetId: Optional[MaintenanceWindowTargetId]
    def getWindowTargetId: ZIO[Any, AwsError, MaintenanceWindowTargetId] =
      AwsError.unwrapOptionField("windowTargetId", windowTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly {
    override val windowTargetId: Optional[MaintenanceWindowTargetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowTargetId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTargetId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
  ): zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly =
    new Wrapper(impl)
}
