package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowTaskInvocationParameters(
    runCommand: Optional[
      zio.aws.ssm.model.MaintenanceWindowRunCommandParameters
    ] = Optional.Absent,
    automation: Optional[
      zio.aws.ssm.model.MaintenanceWindowAutomationParameters
    ] = Optional.Absent,
    stepFunctions: Optional[
      zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters
    ] = Optional.Absent,
    lambda: Optional[zio.aws.ssm.model.MaintenanceWindowLambdaParameters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters = {
    import MaintenanceWindowTaskInvocationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters
      .builder()
      .optionallyWith(runCommand.map(value => value.buildAwsValue()))(
        _.runCommand
      )
      .optionallyWith(automation.map(value => value.buildAwsValue()))(
        _.automation
      )
      .optionallyWith(stepFunctions.map(value => value.buildAwsValue()))(
        _.stepFunctions
      )
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters
      .wrap(buildAwsValue())
}
object MaintenanceWindowTaskInvocationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters =
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters(
        runCommand.map(value => value.asEditable),
        automation.map(value => value.asEditable),
        stepFunctions.map(value => value.asEditable),
        lambda.map(value => value.asEditable)
      )
    def runCommand: Optional[
      zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly
    ]
    def automation: Optional[
      zio.aws.ssm.model.MaintenanceWindowAutomationParameters.ReadOnly
    ]
    def stepFunctions: Optional[
      zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.ReadOnly
    ]
    def lambda
        : Optional[zio.aws.ssm.model.MaintenanceWindowLambdaParameters.ReadOnly]
    def getRunCommand: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly
    ] = AwsError.unwrapOptionField("runCommand", runCommand)
    def getAutomation: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowAutomationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("automation", automation)
    def getStepFunctions: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.ReadOnly
    ] = AwsError.unwrapOptionField("stepFunctions", stepFunctions)
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowLambdaParameters.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters
  ) extends zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly {
    override val runCommand: Optional[
      zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.runCommand())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.wrap(value)
      )
    override val automation: Optional[
      zio.aws.ssm.model.MaintenanceWindowAutomationParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.automation())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowAutomationParameters.wrap(value)
      )
    override val stepFunctions: Optional[
      zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stepFunctions())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.wrap(value)
      )
    override val lambda: Optional[
      zio.aws.ssm.model.MaintenanceWindowLambdaParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambda())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowLambdaParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters
  ): zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly =
    new Wrapper(impl)
}
