package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourceDataSyncResponse(
    resourceDataSyncItems: Optional[
      Iterable[zio.aws.ssm.model.ResourceDataSyncItem]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse = {
    import ListResourceDataSyncResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse
      .builder()
      .optionallyWith(
        resourceDataSyncItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDataSyncItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly =
    zio.aws.ssm.model.ListResourceDataSyncResponse.wrap(buildAwsValue())
}
object ListResourceDataSyncResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListResourceDataSyncResponse =
      zio.aws.ssm.model.ListResourceDataSyncResponse(
        resourceDataSyncItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceDataSyncItems
        : Optional[List[zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getResourceDataSyncItems: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceDataSyncItems", resourceDataSyncItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse
  ) extends zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly {
    override val resourceDataSyncItems
        : Optional[List[zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDataSyncItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ResourceDataSyncItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse
  ): zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly = new Wrapper(impl)
}
