package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemRelatedItemAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateOpsItemRelatedItemResponse(
    associationId: Optional[OpsItemRelatedItemAssociationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse = {
    import AssociateOpsItemRelatedItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse
      .builder()
      .optionallyWith(
        associationId.map(value =>
          OpsItemRelatedItemAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly =
    zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.wrap(buildAwsValue())
}
object AssociateOpsItemRelatedItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse =
      zio.aws.ssm.model
        .AssociateOpsItemRelatedItemResponse(associationId.map(value => value))
    def associationId: Optional[OpsItemRelatedItemAssociationId]
    def getAssociationId: ZIO[Any, AwsError, OpsItemRelatedItemAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse
  ) extends zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly {
    override val associationId: Optional[OpsItemRelatedItemAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.ssm.model.primitives.OpsItemRelatedItemAssociationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse
  ): zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly =
    new Wrapper(impl)
}
