package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait PatchComplianceLevel {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchComplianceLevel
}
object PatchComplianceLevel {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchComplianceLevel
  ): zio.aws.ssm.model.PatchComplianceLevel = value match {
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.INFORMATIONAL =>
      val r = INFORMATIONAL
      r
    case software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.UNSPECIFIED =>
      val r = UNSPECIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.CRITICAL
  }
  case object HIGH extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.HIGH
  }
  case object MEDIUM extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.MEDIUM
  }
  case object LOW extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.LOW
  }
  case object INFORMATIONAL extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.INFORMATIONAL
  }
  case object UNSPECIFIED extends zio.aws.ssm.model.PatchComplianceLevel {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchComplianceLevel =
      software.amazon.awssdk.services.ssm.model.PatchComplianceLevel.UNSPECIFIED
  }
}
