package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait OpsItemEventFilterOperator {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator
}
object OpsItemEventFilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator
  ): zio.aws.ssm.model.OpsItemEventFilterOperator = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator.EQUAL =>
      val r = Equal
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.OpsItemEventFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object Equal extends zio.aws.ssm.model.OpsItemEventFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemEventFilterOperator.EQUAL
  }
}
