package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  DocumentHash,
  DocumentDisplayName,
  DocumentSha1,
  DocumentARN,
  DocumentVersion,
  DateTime,
  DescriptionInDocument,
  DocumentSchemaVersion,
  DocumentAuthor,
  DocumentOwner,
  Category,
  DocumentStatusInformation,
  DocumentVersionName,
  TargetType
}
import scala.jdk.CollectionConverters._
final case class DocumentDescription(
    sha1: Optional[DocumentSha1] = Optional.Absent,
    hash: Optional[DocumentHash] = Optional.Absent,
    hashType: Optional[zio.aws.ssm.model.DocumentHashType] = Optional.Absent,
    name: Optional[DocumentARN] = Optional.Absent,
    displayName: Optional[DocumentDisplayName] = Optional.Absent,
    versionName: Optional[DocumentVersionName] = Optional.Absent,
    owner: Optional[DocumentOwner] = Optional.Absent,
    createdDate: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.DocumentStatus] = Optional.Absent,
    statusInformation: Optional[DocumentStatusInformation] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    description: Optional[DescriptionInDocument] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.ssm.model.DocumentParameter]] =
      Optional.Absent,
    platformTypes: Optional[Iterable[zio.aws.ssm.model.PlatformType]] =
      Optional.Absent,
    documentType: Optional[zio.aws.ssm.model.DocumentType] = Optional.Absent,
    schemaVersion: Optional[DocumentSchemaVersion] = Optional.Absent,
    latestVersion: Optional[DocumentVersion] = Optional.Absent,
    defaultVersion: Optional[DocumentVersion] = Optional.Absent,
    documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      Optional.Absent,
    targetType: Optional[TargetType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent,
    attachmentsInformation: Optional[
      Iterable[zio.aws.ssm.model.AttachmentInformation]
    ] = Optional.Absent,
    requires: Optional[Iterable[zio.aws.ssm.model.DocumentRequires]] =
      Optional.Absent,
    author: Optional[DocumentAuthor] = Optional.Absent,
    reviewInformation: Optional[Iterable[zio.aws.ssm.model.ReviewInformation]] =
      Optional.Absent,
    approvedVersion: Optional[DocumentVersion] = Optional.Absent,
    pendingReviewVersion: Optional[DocumentVersion] = Optional.Absent,
    reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus] = Optional.Absent,
    category: Optional[Iterable[Category]] = Optional.Absent,
    categoryEnum: Optional[Iterable[Category]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentDescription = {
    import DocumentDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentDescription
      .builder()
      .optionallyWith(
        sha1.map(value => DocumentSha1.unwrap(value): java.lang.String)
      )(_.sha1)
      .optionallyWith(
        hash.map(value => DocumentHash.unwrap(value): java.lang.String)
      )(_.hash)
      .optionallyWith(hashType.map(value => value.unwrap))(_.hashType)
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        owner.map(value => DocumentOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusInformation.map(value =>
          DocumentStatusInformation.unwrap(value): java.lang.String
        )
      )(_.statusInformation)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        description.map(value =>
          DescriptionInDocument.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        platformTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformTypesWithStrings)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(
        schemaVersion.map(value =>
          DocumentSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.schemaVersion)
      .optionallyWith(
        latestVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.latestVersion)
      .optionallyWith(
        defaultVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.defaultVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        attachmentsInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentsInformation)
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(
        author.map(value => DocumentAuthor.unwrap(value): java.lang.String)
      )(_.author)
      .optionallyWith(
        reviewInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reviewInformation)
      .optionallyWith(
        approvedVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.approvedVersion)
      .optionallyWith(
        pendingReviewVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.pendingReviewVersion)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .optionallyWith(
        category.map(value =>
          value.map { item =>
            Category.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.category)
      .optionallyWith(
        categoryEnum.map(value =>
          value.map { item =>
            Category.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.categoryEnum)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentDescription.ReadOnly =
    zio.aws.ssm.model.DocumentDescription.wrap(buildAwsValue())
}
object DocumentDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentDescription =
      zio.aws.ssm.model.DocumentDescription(
        sha1.map(value => value),
        hash.map(value => value),
        hashType.map(value => value),
        name.map(value => value),
        displayName.map(value => value),
        versionName.map(value => value),
        owner.map(value => value),
        createdDate.map(value => value),
        status.map(value => value),
        statusInformation.map(value => value),
        documentVersion.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformTypes.map(value => value),
        documentType.map(value => value),
        schemaVersion.map(value => value),
        latestVersion.map(value => value),
        defaultVersion.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachmentsInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        author.map(value => value),
        reviewInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        approvedVersion.map(value => value),
        pendingReviewVersion.map(value => value),
        reviewStatus.map(value => value),
        category.map(value => value),
        categoryEnum.map(value => value)
      )
    def sha1: Optional[DocumentSha1]
    def hash: Optional[DocumentHash]
    def hashType: Optional[zio.aws.ssm.model.DocumentHashType]
    def name: Optional[DocumentARN]
    def displayName: Optional[DocumentDisplayName]
    def versionName: Optional[DocumentVersionName]
    def owner: Optional[DocumentOwner]
    def createdDate: Optional[DateTime]
    def status: Optional[zio.aws.ssm.model.DocumentStatus]
    def statusInformation: Optional[DocumentStatusInformation]
    def documentVersion: Optional[DocumentVersion]
    def description: Optional[DescriptionInDocument]
    def parameters: Optional[List[zio.aws.ssm.model.DocumentParameter.ReadOnly]]
    def platformTypes: Optional[List[zio.aws.ssm.model.PlatformType]]
    def documentType: Optional[zio.aws.ssm.model.DocumentType]
    def schemaVersion: Optional[DocumentSchemaVersion]
    def latestVersion: Optional[DocumentVersion]
    def defaultVersion: Optional[DocumentVersion]
    def documentFormat: Optional[zio.aws.ssm.model.DocumentFormat]
    def targetType: Optional[TargetType]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def attachmentsInformation
        : Optional[List[zio.aws.ssm.model.AttachmentInformation.ReadOnly]]
    def requires: Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def author: Optional[DocumentAuthor]
    def reviewInformation
        : Optional[List[zio.aws.ssm.model.ReviewInformation.ReadOnly]]
    def approvedVersion: Optional[DocumentVersion]
    def pendingReviewVersion: Optional[DocumentVersion]
    def reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus]
    def category: Optional[List[Category]]
    def categoryEnum: Optional[List[Category]]
    def getSha1: ZIO[Any, AwsError, DocumentSha1] =
      AwsError.unwrapOptionField("sha1", sha1)
    def getHash: ZIO[Any, AwsError, DocumentHash] =
      AwsError.unwrapOptionField("hash", hash)
    def getHashType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentHashType] =
      AwsError.unwrapOptionField("hashType", hashType)
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getOwner: ZIO[Any, AwsError, DocumentOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusInformation: ZIO[Any, AwsError, DocumentStatusInformation] =
      AwsError.unwrapOptionField("statusInformation", statusInformation)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDescription: ZIO[Any, AwsError, DescriptionInDocument] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getPlatformTypes
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PlatformType]] =
      AwsError.unwrapOptionField("platformTypes", platformTypes)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getSchemaVersion: ZIO[Any, AwsError, DocumentSchemaVersion] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getLatestVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("latestVersion", latestVersion)
    def getDefaultVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAttachmentsInformation: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachmentsInformation",
      attachmentsInformation
    )
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getAuthor: ZIO[Any, AwsError, DocumentAuthor] =
      AwsError.unwrapOptionField("author", author)
    def getReviewInformation: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ReviewInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("reviewInformation", reviewInformation)
    def getApprovedVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("approvedVersion", approvedVersion)
    def getPendingReviewVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("pendingReviewVersion", pendingReviewVersion)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
    def getCategory: ZIO[Any, AwsError, List[Category]] =
      AwsError.unwrapOptionField("category", category)
    def getCategoryEnum: ZIO[Any, AwsError, List[Category]] =
      AwsError.unwrapOptionField("categoryEnum", categoryEnum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentDescription
  ) extends zio.aws.ssm.model.DocumentDescription.ReadOnly {
    override val sha1: Optional[DocumentSha1] = zio.aws.core.internal
      .optionalFromNullable(impl.sha1())
      .map(value => zio.aws.ssm.model.primitives.DocumentSha1(value))
    override val hash: Optional[DocumentHash] = zio.aws.core.internal
      .optionalFromNullable(impl.hash())
      .map(value => zio.aws.ssm.model.primitives.DocumentHash(value))
    override val hashType: Optional[zio.aws.ssm.model.DocumentHashType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hashType())
        .map(value => zio.aws.ssm.model.DocumentHashType.wrap(value))
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val displayName: Optional[DocumentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Optional[DocumentVersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionName())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val owner: Optional[DocumentOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.ssm.model.primitives.DocumentOwner(value))
    override val createdDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.ssm.model.DocumentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.DocumentStatus.wrap(value))
    override val statusInformation: Optional[DocumentStatusInformation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusInformation())
        .map(value =>
          zio.aws.ssm.model.primitives.DocumentStatusInformation(value)
        )
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val description: Optional[DescriptionInDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.DescriptionInDocument(value))
    override val parameters
        : Optional[List[zio.aws.ssm.model.DocumentParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentParameter.wrap(item)
          }.toList
        )
    override val platformTypes: Optional[List[zio.aws.ssm.model.PlatformType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PlatformType.wrap(item)
          }.toList
        )
    override val documentType: Optional[zio.aws.ssm.model.DocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentType())
        .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val schemaVersion: Optional[DocumentSchemaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentSchemaVersion(value))
    override val latestVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val defaultVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Optional[TargetType] = zio.aws.core.internal
      .optionalFromNullable(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
    override val attachmentsInformation
        : Optional[List[zio.aws.ssm.model.AttachmentInformation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentsInformation())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AttachmentInformation.wrap(item)
          }.toList
        )
    override val requires
        : Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requires())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentRequires.wrap(item)
          }.toList
        )
    override val author: Optional[DocumentAuthor] = zio.aws.core.internal
      .optionalFromNullable(impl.author())
      .map(value => zio.aws.ssm.model.primitives.DocumentAuthor(value))
    override val reviewInformation
        : Optional[List[zio.aws.ssm.model.ReviewInformation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reviewInformation())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ReviewInformation.wrap(item)
          }.toList
        )
    override val approvedVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val pendingReviewVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingReviewVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reviewStatus())
        .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val category: Optional[List[Category]] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Category(item)
        }.toList
      )
    override val categoryEnum: Optional[List[Category]] = zio.aws.core.internal
      .optionalFromNullable(impl.categoryEnum())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Category(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentDescription
  ): zio.aws.ssm.model.DocumentDescription.ReadOnly = new Wrapper(impl)
}
