package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait AssociationSyncCompliance {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance
}
object AssociationSyncCompliance {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance
  ): zio.aws.ssm.model.AssociationSyncCompliance = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance.MANUAL =>
      val r = MANUAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationSyncCompliance {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance =
      software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.ssm.model.AssociationSyncCompliance {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance =
      software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance.AUTO
  }
  case object MANUAL extends zio.aws.ssm.model.AssociationSyncCompliance {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance =
      software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance.MANUAL
  }
}
