package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait InventoryAttributeDataType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType
}
object InventoryAttributeDataType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType
  ): zio.aws.ssm.model.InventoryAttributeDataType = value match {
    case software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType.STRING =>
      val r = string
      r
    case software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType.NUMBER =>
      val r = number
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InventoryAttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType =
      software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object string extends zio.aws.ssm.model.InventoryAttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType =
      software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType.STRING
  }
  case object number extends zio.aws.ssm.model.InventoryAttributeDataType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType =
      software.amazon.awssdk.services.ssm.model.InventoryAttributeDataType.NUMBER
  }
}
