package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  AssociationId,
  StatusName,
  DocumentARN,
  InstanceId,
  AgentErrorCode,
  AssociationName,
  DocumentVersion,
  DateTime,
  AssociationVersion,
  InstanceAssociationExecutionSummary
}
import scala.jdk.CollectionConverters._
final case class InstanceAssociationStatusInfo(
    associationId: Optional[AssociationId] = Optional.Absent,
    name: Optional[DocumentARN] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    executionDate: Optional[DateTime] = Optional.Absent,
    status: Optional[StatusName] = Optional.Absent,
    detailedStatus: Optional[StatusName] = Optional.Absent,
    executionSummary: Optional[InstanceAssociationExecutionSummary] =
      Optional.Absent,
    errorCode: Optional[AgentErrorCode] = Optional.Absent,
    outputUrl: Optional[zio.aws.ssm.model.InstanceAssociationOutputUrl] =
      Optional.Absent,
    associationName: Optional[AssociationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo = {
    import InstanceAssociationStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        executionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.executionDate)
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        executionSummary.map(value =>
          InstanceAssociationExecutionSummary.unwrap(value): java.lang.String
        )
      )(_.executionSummary)
      .optionallyWith(
        errorCode.map(value => AgentErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(outputUrl.map(value => value.buildAwsValue()))(
        _.outputUrl
      )
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly =
    zio.aws.ssm.model.InstanceAssociationStatusInfo.wrap(buildAwsValue())
}
object InstanceAssociationStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAssociationStatusInfo =
      zio.aws.ssm.model.InstanceAssociationStatusInfo(
        associationId.map(value => value),
        name.map(value => value),
        documentVersion.map(value => value),
        associationVersion.map(value => value),
        instanceId.map(value => value),
        executionDate.map(value => value),
        status.map(value => value),
        detailedStatus.map(value => value),
        executionSummary.map(value => value),
        errorCode.map(value => value),
        outputUrl.map(value => value.asEditable),
        associationName.map(value => value)
      )
    def associationId: Optional[AssociationId]
    def name: Optional[DocumentARN]
    def documentVersion: Optional[DocumentVersion]
    def associationVersion: Optional[AssociationVersion]
    def instanceId: Optional[InstanceId]
    def executionDate: Optional[DateTime]
    def status: Optional[StatusName]
    def detailedStatus: Optional[StatusName]
    def executionSummary: Optional[InstanceAssociationExecutionSummary]
    def errorCode: Optional[AgentErrorCode]
    def outputUrl
        : Optional[zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly]
    def associationName: Optional[AssociationName]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionDate", executionDate)
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getExecutionSummary
        : ZIO[Any, AwsError, InstanceAssociationExecutionSummary] =
      AwsError.unwrapOptionField("executionSummary", executionSummary)
    def getErrorCode: ZIO[Any, AwsError, AgentErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getOutputUrl: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly
    ] = AwsError.unwrapOptionField("outputUrl", outputUrl)
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
  ) extends zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val executionDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.executionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val executionSummary
        : Optional[InstanceAssociationExecutionSummary] = zio.aws.core.internal
      .optionalFromNullable(impl.executionSummary())
      .map(value =>
        zio.aws.ssm.model.primitives.InstanceAssociationExecutionSummary(value)
      )
    override val errorCode: Optional[AgentErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.ssm.model.primitives.AgentErrorCode(value))
    override val outputUrl
        : Optional[zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputUrl())
        .map(value =>
          zio.aws.ssm.model.InstanceAssociationOutputUrl.wrap(value)
        )
    override val associationName: Optional[AssociationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationName())
        .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
  ): zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly = new Wrapper(
    impl
  )
}
