package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  SnapshotDownloadUrl,
  SnapshotId,
  InstanceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeployablePatchSnapshotForInstanceResponse(
    instanceId: Optional[InstanceId] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    snapshotDownloadUrl: Optional[SnapshotDownloadUrl] = Optional.Absent,
    product: Optional[zio.aws.ssm.model.primitives.Product] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse = {
    import GetDeployablePatchSnapshotForInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        snapshotDownloadUrl.map(value =>
          SnapshotDownloadUrl.unwrap(value): java.lang.String
        )
      )(_.snapshotDownloadUrl)
      .optionallyWith(
        product.map(value =>
          zio.aws.ssm.model.primitives.Product.unwrap(value): java.lang.String
        )
      )(_.product)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly =
    zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
      .wrap(buildAwsValue())
}
object GetDeployablePatchSnapshotForInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse =
      zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse(
        instanceId.map(value => value),
        snapshotId.map(value => value),
        snapshotDownloadUrl.map(value => value),
        product.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def snapshotId: Optional[SnapshotId]
    def snapshotDownloadUrl: Optional[SnapshotDownloadUrl]
    def product: Optional[zio.aws.ssm.model.primitives.Product]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getSnapshotDownloadUrl: ZIO[Any, AwsError, SnapshotDownloadUrl] =
      AwsError.unwrapOptionField("snapshotDownloadUrl", snapshotDownloadUrl)
    def getProduct: ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Product] =
      AwsError.unwrapOptionField("product", product)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
  ) extends zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ssm.model.primitives.SnapshotId(value))
    override val snapshotDownloadUrl: Optional[SnapshotDownloadUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotDownloadUrl())
        .map(value => zio.aws.ssm.model.primitives.SnapshotDownloadUrl(value))
    override val product: Optional[zio.aws.ssm.model.primitives.Product] =
      zio.aws.core.internal
        .optionalFromNullable(impl.product())
        .map(value => zio.aws.ssm.model.primitives.Product(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
  ): zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
