package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttachmentIdentifier,
  AttachmentsSourceValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachmentsSource(
    key: Optional[zio.aws.ssm.model.AttachmentsSourceKey] = Optional.Absent,
    values: Optional[Iterable[AttachmentsSourceValue]] = Optional.Absent,
    name: Optional[AttachmentIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AttachmentsSource = {
    import AttachmentsSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AttachmentsSource
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            AttachmentsSourceValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        name.map(value => AttachmentIdentifier.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AttachmentsSource.ReadOnly =
    zio.aws.ssm.model.AttachmentsSource.wrap(buildAwsValue())
}
object AttachmentsSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AttachmentsSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AttachmentsSource =
      zio.aws.ssm.model.AttachmentsSource(
        key.map(value => value),
        values.map(value => value),
        name.map(value => value)
      )
    def key: Optional[zio.aws.ssm.model.AttachmentsSourceKey]
    def values: Optional[List[AttachmentsSourceValue]]
    def name: Optional[AttachmentIdentifier]
    def getKey: ZIO[Any, AwsError, zio.aws.ssm.model.AttachmentsSourceKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[AttachmentsSourceValue]] =
      AwsError.unwrapOptionField("values", values)
    def getName: ZIO[Any, AwsError, AttachmentIdentifier] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentsSource
  ) extends zio.aws.ssm.model.AttachmentsSource.ReadOnly {
    override val key: Optional[zio.aws.ssm.model.AttachmentsSourceKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value => zio.aws.ssm.model.AttachmentsSourceKey.wrap(value))
    override val values: Optional[List[AttachmentsSourceValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.AttachmentsSourceValue(item)
          }.toList
        )
    override val name: Optional[AttachmentIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.AttachmentIdentifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentsSource
  ): zio.aws.ssm.model.AttachmentsSource.ReadOnly = new Wrapper(impl)
}
