package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ResourceDataSyncOrganizationSourceType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceDataSyncAwsOrganizationsSource(
    organizationSourceType: ResourceDataSyncOrganizationSourceType,
    organizationalUnits: Optional[
      Iterable[zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = {
    import ResourceDataSyncAwsOrganizationsSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncAwsOrganizationsSource
      .builder()
      .organizationSourceType(
        ResourceDataSyncOrganizationSourceType.unwrap(
          organizationSourceType
        ): java.lang.String
      )
      .optionallyWith(
        organizationalUnits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationalUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource
      .wrap(buildAwsValue())
}
object ResourceDataSyncAwsOrganizationsSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncAwsOrganizationsSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource =
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource(
        organizationSourceType,
        organizationalUnits.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def organizationSourceType: ResourceDataSyncOrganizationSourceType
    def organizationalUnits: Optional[
      List[zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.ReadOnly]
    ]
    def getOrganizationSourceType
        : ZIO[Any, Nothing, ResourceDataSyncOrganizationSourceType] =
      ZIO.succeed(organizationSourceType)
    def getOrganizationalUnits: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.ReadOnly
    ]] = AwsError.unwrapOptionField("organizationalUnits", organizationalUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncAwsOrganizationsSource
  ) extends zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly {
    override val organizationSourceType
        : ResourceDataSyncOrganizationSourceType = zio.aws.ssm.model.primitives
      .ResourceDataSyncOrganizationSourceType(impl.organizationSourceType())
    override val organizationalUnits: Optional[
      List[zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncAwsOrganizationsSource
  ): zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly =
    new Wrapper(impl)
}
