package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class OpsItemEventSummary(
    opsItemId: Optional[String] = Optional.Absent,
    eventId: Optional[String] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    detailType: Optional[String] = Optional.Absent,
    detail: Optional[String] = Optional.Absent,
    createdBy: Optional[zio.aws.ssm.model.OpsItemIdentity] = Optional.Absent,
    createdTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemEventSummary = {
    import OpsItemEventSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
      .builder()
      .optionallyWith(opsItemId.map(value => value: java.lang.String))(
        _.opsItemId
      )
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(detailType.map(value => value: java.lang.String))(
        _.detailType
      )
      .optionallyWith(detail.map(value => value: java.lang.String))(_.detail)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemEventSummary.ReadOnly =
    zio.aws.ssm.model.OpsItemEventSummary.wrap(buildAwsValue())
}
object OpsItemEventSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemEventSummary =
      zio.aws.ssm.model.OpsItemEventSummary(
        opsItemId.map(value => value),
        eventId.map(value => value),
        source.map(value => value),
        detailType.map(value => value),
        detail.map(value => value),
        createdBy.map(value => value.asEditable),
        createdTime.map(value => value)
      )
    def opsItemId: Optional[String]
    def eventId: Optional[String]
    def source: Optional[String]
    def detailType: Optional[String]
    def detail: Optional[String]
    def createdBy: Optional[zio.aws.ssm.model.OpsItemIdentity.ReadOnly]
    def createdTime: Optional[DateTime]
    def getOpsItemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDetailType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detailType", detailType)
    def getDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detail", detail)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
  ) extends zio.aws.ssm.model.OpsItemEventSummary.ReadOnly {
    override val opsItemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => value: String)
    override val eventId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => value: String)
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val detailType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detailType())
      .map(value => value: String)
    override val detail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detail())
      .map(value => value: String)
    override val createdBy
        : Optional[zio.aws.ssm.model.OpsItemIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.ssm.model.OpsItemIdentity.wrap(value))
    override val createdTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemEventSummary
  ): zio.aws.ssm.model.OpsItemEventSummary.ReadOnly = new Wrapper(impl)
}
