package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentVersionName,
  RequireType,
  DocumentVersion,
  DocumentARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentRequires(
    name: DocumentARN,
    version: Optional[DocumentVersion] = Optional.Absent,
    requireType: Optional[RequireType] = Optional.Absent,
    versionName: Optional[DocumentVersionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentRequires = {
    import DocumentRequires.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentRequires
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .optionallyWith(
        version.map(value => DocumentVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        requireType.map(value => RequireType.unwrap(value): java.lang.String)
      )(_.requireType)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentRequires.ReadOnly =
    zio.aws.ssm.model.DocumentRequires.wrap(buildAwsValue())
}
object DocumentRequires {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentRequires
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentRequires =
      zio.aws.ssm.model.DocumentRequires(
        name,
        version.map(value => value),
        requireType.map(value => value),
        versionName.map(value => value)
      )
    def name: DocumentARN
    def version: Optional[DocumentVersion]
    def requireType: Optional[RequireType]
    def versionName: Optional[DocumentVersionName]
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("version", version)
    def getRequireType: ZIO[Any, AwsError, RequireType] =
      AwsError.unwrapOptionField("requireType", requireType)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentRequires
  ) extends zio.aws.ssm.model.DocumentRequires.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val version: Optional[DocumentVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val requireType: Optional[RequireType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireType())
      .map(value => zio.aws.ssm.model.primitives.RequireType(value))
    override val versionName: Optional[DocumentVersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionName())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentRequires
  ): zio.aws.ssm.model.DocumentRequires.ReadOnly = new Wrapper(impl)
}
