package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttributeName,
  ComplianceResourceType,
  ComplianceItemTitle,
  ComplianceItemId,
  ComplianceResourceId,
  ComplianceTypeName,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComplianceItem(
    complianceType: Optional[ComplianceTypeName] = Optional.Absent,
    resourceType: Optional[ComplianceResourceType] = Optional.Absent,
    resourceId: Optional[ComplianceResourceId] = Optional.Absent,
    id: Optional[ComplianceItemId] = Optional.Absent,
    title: Optional[ComplianceItemTitle] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.ComplianceStatus] = Optional.Absent,
    severity: Optional[zio.aws.ssm.model.ComplianceSeverity] = Optional.Absent,
    executionSummary: Optional[zio.aws.ssm.model.ComplianceExecutionSummary] =
      Optional.Absent,
    details: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ComplianceItem = {
    import ComplianceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ComplianceItem
      .builder()
      .optionallyWith(
        complianceType.map(value =>
          ComplianceTypeName.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        resourceType.map(value =>
          ComplianceResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ComplianceResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        id.map(value => ComplianceItemId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        title.map(value => ComplianceItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(executionSummary.map(value => value.buildAwsValue()))(
        _.executionSummary
      )
      .optionallyWith(
        details.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ComplianceItem.ReadOnly =
    zio.aws.ssm.model.ComplianceItem.wrap(buildAwsValue())
}
object ComplianceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ComplianceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ComplianceItem =
      zio.aws.ssm.model.ComplianceItem(
        complianceType.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        id.map(value => value),
        title.map(value => value),
        status.map(value => value),
        severity.map(value => value),
        executionSummary.map(value => value.asEditable),
        details.map(value => value)
      )
    def complianceType: Optional[ComplianceTypeName]
    def resourceType: Optional[ComplianceResourceType]
    def resourceId: Optional[ComplianceResourceId]
    def id: Optional[ComplianceItemId]
    def title: Optional[ComplianceItemTitle]
    def status: Optional[zio.aws.ssm.model.ComplianceStatus]
    def severity: Optional[zio.aws.ssm.model.ComplianceSeverity]
    def executionSummary
        : Optional[zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly]
    def details: Optional[Map[AttributeName, AttributeValue]]
    def getComplianceType: ZIO[Any, AwsError, ComplianceTypeName] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getResourceType: ZIO[Any, AwsError, ComplianceResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ComplianceResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getId: ZIO[Any, AwsError, ComplianceItemId] =
      AwsError.unwrapOptionField("id", id)
    def getTitle: ZIO[Any, AwsError, ComplianceItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSeverity: ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getExecutionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("executionSummary", executionSummary)
    def getDetails: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceItem
  ) extends zio.aws.ssm.model.ComplianceItem.ReadOnly {
    override val complianceType: Optional[ComplianceTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value => zio.aws.ssm.model.primitives.ComplianceTypeName(value))
    override val resourceType: Optional[ComplianceResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceResourceType(value)
        )
    override val resourceId: Optional[ComplianceResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value => zio.aws.ssm.model.primitives.ComplianceResourceId(value))
    override val id: Optional[ComplianceItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ssm.model.primitives.ComplianceItemId(value))
    override val title: Optional[ComplianceItemTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.ssm.model.primitives.ComplianceItemTitle(value))
    override val status: Optional[zio.aws.ssm.model.ComplianceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.ComplianceStatus.wrap(value))
    override val severity: Optional[zio.aws.ssm.model.ComplianceSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.ssm.model.ComplianceSeverity.wrap(value))
    override val executionSummary
        : Optional[zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionSummary())
        .map(value => zio.aws.ssm.model.ComplianceExecutionSummary.wrap(value))
    override val details: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives.AttributeName(
                key
              ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ComplianceItem
  ): zio.aws.ssm.model.ComplianceItem.ReadOnly = new Wrapper(impl)
}
