package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  AutomationParameterValue,
  AutomationParameterKey,
  DateTime,
  AutomationActionName,
  ValidNextStep
}
import scala.jdk.CollectionConverters._
final case class StepExecution(
    stepName: Optional[String] = Optional.Absent,
    action: Optional[AutomationActionName] = Optional.Absent,
    timeoutSeconds: Optional[Long] = Optional.Absent,
    onFailure: Optional[String] = Optional.Absent,
    maxAttempts: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent,
    executionStartTime: Optional[DateTime] = Optional.Absent,
    executionEndTime: Optional[DateTime] = Optional.Absent,
    stepStatus: Optional[zio.aws.ssm.model.AutomationExecutionStatus] =
      Optional.Absent,
    responseCode: Optional[String] = Optional.Absent,
    inputs: Optional[Map[String, String]] = Optional.Absent,
    outputs: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    response: Optional[String] = Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent,
    failureDetails: Optional[zio.aws.ssm.model.FailureDetails] =
      Optional.Absent,
    stepExecutionId: Optional[String] = Optional.Absent,
    overriddenParameters: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    isEnd: Optional[Boolean] = Optional.Absent,
    nextStep: Optional[String] = Optional.Absent,
    isCritical: Optional[Boolean] = Optional.Absent,
    validNextSteps: Optional[Iterable[ValidNextStep]] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    targetLocation: Optional[zio.aws.ssm.model.TargetLocation] =
      Optional.Absent,
    triggeredAlarms: Optional[
      Iterable[zio.aws.ssm.model.AlarmStateInformation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StepExecution = {
    import StepExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StepExecution
      .builder()
      .optionallyWith(stepName.map(value => value: java.lang.String))(
        _.stepName
      )
      .optionallyWith(
        action.map(value =>
          AutomationActionName.unwrap(value): java.lang.String
        )
      )(_.action)
      .optionallyWith(timeoutSeconds.map(value => value: java.lang.Long))(
        _.timeoutSeconds
      )
      .optionallyWith(onFailure.map(value => value: java.lang.String))(
        _.onFailure
      )
      .optionallyWith(maxAttempts.map(value => value: Integer))(_.maxAttempts)
      .optionallyWith(
        executionStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionStartTime)
      .optionallyWith(
        executionEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionEndTime)
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(responseCode.map(value => value: java.lang.String))(
        _.responseCode
      )
      .optionallyWith(
        inputs.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.inputs)
      .optionallyWith(
        outputs.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.outputs)
      .optionallyWith(response.map(value => value: java.lang.String))(
        _.response
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(stepExecutionId.map(value => value: java.lang.String))(
        _.stepExecutionId
      )
      .optionallyWith(
        overriddenParameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.overriddenParameters)
      .optionallyWith(isEnd.map(value => value: java.lang.Boolean))(_.isEnd)
      .optionallyWith(nextStep.map(value => value: java.lang.String))(
        _.nextStep
      )
      .optionallyWith(isCritical.map(value => value: java.lang.Boolean))(
        _.isCritical
      )
      .optionallyWith(
        validNextSteps.map(value =>
          value.map { item =>
            ValidNextStep.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validNextSteps)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(targetLocation.map(value => value.buildAwsValue()))(
        _.targetLocation
      )
      .optionallyWith(
        triggeredAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggeredAlarms)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StepExecution.ReadOnly =
    zio.aws.ssm.model.StepExecution.wrap(buildAwsValue())
}
object StepExecution {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.StepExecution] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StepExecution =
      zio.aws.ssm.model.StepExecution(
        stepName.map(value => value),
        action.map(value => value),
        timeoutSeconds.map(value => value),
        onFailure.map(value => value),
        maxAttempts.map(value => value),
        executionStartTime.map(value => value),
        executionEndTime.map(value => value),
        stepStatus.map(value => value),
        responseCode.map(value => value),
        inputs.map(value => value),
        outputs.map(value => value),
        response.map(value => value),
        failureMessage.map(value => value),
        failureDetails.map(value => value.asEditable),
        stepExecutionId.map(value => value),
        overriddenParameters.map(value => value),
        isEnd.map(value => value),
        nextStep.map(value => value),
        isCritical.map(value => value),
        validNextSteps.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetLocation.map(value => value.asEditable),
        triggeredAlarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stepName: Optional[String]
    def action: Optional[AutomationActionName]
    def timeoutSeconds: Optional[Long]
    def onFailure: Optional[String]
    def maxAttempts: Optional[zio.aws.ssm.model.primitives.Integer]
    def executionStartTime: Optional[DateTime]
    def executionEndTime: Optional[DateTime]
    def stepStatus: Optional[zio.aws.ssm.model.AutomationExecutionStatus]
    def responseCode: Optional[String]
    def inputs: Optional[Map[String, String]]
    def outputs
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def response: Optional[String]
    def failureMessage: Optional[String]
    def failureDetails: Optional[zio.aws.ssm.model.FailureDetails.ReadOnly]
    def stepExecutionId: Optional[String]
    def overriddenParameters
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def isEnd: Optional[Boolean]
    def nextStep: Optional[String]
    def isCritical: Optional[Boolean]
    def validNextSteps: Optional[List[ValidNextStep]]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetLocation: Optional[zio.aws.ssm.model.TargetLocation.ReadOnly]
    def triggeredAlarms
        : Optional[List[zio.aws.ssm.model.AlarmStateInformation.ReadOnly]]
    def getStepName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepName", stepName)
    def getAction: ZIO[Any, AwsError, AutomationActionName] =
      AwsError.unwrapOptionField("action", action)
    def getTimeoutSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
    def getOnFailure: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onFailure", onFailure)
    def getMaxAttempts
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("maxAttempts", maxAttempts)
    def getExecutionStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionStartTime", executionStartTime)
    def getExecutionEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionEndTime", executionEndTime)
    def getStepStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationExecutionStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getResponseCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getInputs: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("inputs", inputs)
    def getOutputs: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("outputs", outputs)
    def getResponse: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("response", response)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getFailureDetails
        : ZIO[Any, AwsError, zio.aws.ssm.model.FailureDetails.ReadOnly] =
      AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getStepExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepExecutionId", stepExecutionId)
    def getOverriddenParameters
        : ZIO[Any, AwsError, Map[AutomationParameterKey, List[
          AutomationParameterValue
        ]]] =
      AwsError.unwrapOptionField("overriddenParameters", overriddenParameters)
    def getIsEnd: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnd", isEnd)
    def getNextStep: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextStep", nextStep)
    def getIsCritical: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCritical", isCritical)
    def getValidNextSteps: ZIO[Any, AwsError, List[ValidNextStep]] =
      AwsError.unwrapOptionField("validNextSteps", validNextSteps)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetLocation
        : ZIO[Any, AwsError, zio.aws.ssm.model.TargetLocation.ReadOnly] =
      AwsError.unwrapOptionField("targetLocation", targetLocation)
    def getTriggeredAlarms: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AlarmStateInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("triggeredAlarms", triggeredAlarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StepExecution
  ) extends zio.aws.ssm.model.StepExecution.ReadOnly {
    override val stepName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepName())
      .map(value => value: String)
    override val action: Optional[AutomationActionName] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => zio.aws.ssm.model.primitives.AutomationActionName(value))
    override val timeoutSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutSeconds())
      .map(value => value: Long)
    override val onFailure: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.onFailure())
      .map(value => value: String)
    override val maxAttempts: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAttempts())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val executionStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val executionEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.executionEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val stepStatus
        : Optional[zio.aws.ssm.model.AutomationExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepStatus())
        .map(value => zio.aws.ssm.model.AutomationExecutionStatus.wrap(value))
    override val responseCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.responseCode())
      .map(value => value: String)
    override val inputs: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.inputs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val outputs: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val response: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.response())
      .map(value => value: String)
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val failureDetails
        : Optional[zio.aws.ssm.model.FailureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDetails())
        .map(value => zio.aws.ssm.model.FailureDetails.wrap(value))
    override val stepExecutionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepExecutionId())
      .map(value => value: String)
    override val overriddenParameters: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.overriddenParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val isEnd: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnd())
      .map(value => value: Boolean)
    override val nextStep: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextStep())
      .map(value => value: String)
    override val isCritical: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isCritical())
      .map(value => value: Boolean)
    override val validNextSteps: Optional[List[ValidNextStep]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validNextSteps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ValidNextStep(item)
          }.toList
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetLocation
        : Optional[zio.aws.ssm.model.TargetLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocation())
        .map(value => zio.aws.ssm.model.TargetLocation.wrap(value))
    override val triggeredAlarms
        : Optional[List[zio.aws.ssm.model.AlarmStateInformation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggeredAlarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AlarmStateInformation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StepExecution
  ): zio.aws.ssm.model.StepExecution.ReadOnly = new Wrapper(impl)
}
