package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ResourceTypeForTagging {
  def unwrap: software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging
}
object ResourceTypeForTagging {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging
  ): zio.aws.ssm.model.ResourceTypeForTagging = value match {
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.DOCUMENT =>
      val r = Document
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.MANAGED_INSTANCE =>
      val r = ManagedInstance
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.MAINTENANCE_WINDOW =>
      val r = MaintenanceWindow
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.PARAMETER =>
      val r = Parameter
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.PATCH_BASELINE =>
      val r = PatchBaseline
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.OPS_ITEM =>
      val r = OpsItem
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.OPS_METADATA =>
      val r = OpsMetadata
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.AUTOMATION =>
      val r = Automation
      r
    case software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.ASSOCIATION =>
      val r = Association
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.UNKNOWN_TO_SDK_VERSION
  }
  case object Document extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.DOCUMENT
  }
  case object ManagedInstance extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.MANAGED_INSTANCE
  }
  case object MaintenanceWindow
      extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.MAINTENANCE_WINDOW
  }
  case object Parameter extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.PARAMETER
  }
  case object PatchBaseline extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.PATCH_BASELINE
  }
  case object OpsItem extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.OPS_ITEM
  }
  case object OpsMetadata extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.OPS_METADATA
  }
  case object Automation extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.AUTOMATION
  }
  case object Association extends zio.aws.ssm.model.ResourceTypeForTagging {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging =
      software.amazon.awssdk.services.ssm.model.ResourceTypeForTagging.ASSOCIATION
  }
}
