package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{OutputSourceType, OutputSourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputSource(
    outputSourceId: Optional[OutputSourceId] = Optional.Absent,
    outputSourceType: Optional[OutputSourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OutputSource = {
    import OutputSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OutputSource
      .builder()
      .optionallyWith(
        outputSourceId.map(value =>
          OutputSourceId.unwrap(value): java.lang.String
        )
      )(_.outputSourceId)
      .optionallyWith(
        outputSourceType.map(value =>
          OutputSourceType.unwrap(value): java.lang.String
        )
      )(_.outputSourceType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OutputSource.ReadOnly =
    zio.aws.ssm.model.OutputSource.wrap(buildAwsValue())
}
object OutputSource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OutputSource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OutputSource =
      zio.aws.ssm.model.OutputSource(
        outputSourceId.map(value => value),
        outputSourceType.map(value => value)
      )
    def outputSourceId: Optional[OutputSourceId]
    def outputSourceType: Optional[OutputSourceType]
    def getOutputSourceId: ZIO[Any, AwsError, OutputSourceId] =
      AwsError.unwrapOptionField("outputSourceId", outputSourceId)
    def getOutputSourceType: ZIO[Any, AwsError, OutputSourceType] =
      AwsError.unwrapOptionField("outputSourceType", outputSourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OutputSource
  ) extends zio.aws.ssm.model.OutputSource.ReadOnly {
    override val outputSourceId: Optional[OutputSourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputSourceId())
        .map(value => zio.aws.ssm.model.primitives.OutputSourceId(value))
    override val outputSourceType: Optional[OutputSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputSourceType())
        .map(value => zio.aws.ssm.model.primitives.OutputSourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OutputSource
  ): zio.aws.ssm.model.OutputSource.ReadOnly = new Wrapper(impl)
}
