package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MetadataValueString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetadataValue(
    value: Optional[MetadataValueString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MetadataValue = {
    import MetadataValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MetadataValue
      .builder()
      .optionallyWith(
        value.map(value => MetadataValueString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MetadataValue.ReadOnly =
    zio.aws.ssm.model.MetadataValue.wrap(buildAwsValue())
}
object MetadataValue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.MetadataValue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MetadataValue =
      zio.aws.ssm.model.MetadataValue(value.map(value => value))
    def value: Optional[MetadataValueString]
    def getValue: ZIO[Any, AwsError, MetadataValueString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MetadataValue
  ) extends zio.aws.ssm.model.MetadataValue.ReadOnly {
    override val value: Optional[MetadataValueString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.ssm.model.primitives.MetadataValueString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MetadataValue
  ): zio.aws.ssm.model.MetadataValue.ReadOnly = new Wrapper(impl)
}
