package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  InventoryItemTypeName,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class ListInventoryEntriesRequest(
    instanceId: InstanceId,
    typeName: InventoryItemTypeName,
    filters: Optional[Iterable[zio.aws.ssm.model.InventoryFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest = {
    import ListInventoryEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListInventoryEntriesRequest.ReadOnly =
    zio.aws.ssm.model.ListInventoryEntriesRequest.wrap(buildAwsValue())
}
object ListInventoryEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListInventoryEntriesRequest =
      zio.aws.ssm.model.ListInventoryEntriesRequest(
        instanceId,
        typeName,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def typeName: InventoryItemTypeName
    def filters: Optional[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
  ) extends zio.aws.ssm.model.ListInventoryEntriesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
    override val filters
        : Optional[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest
  ): zio.aws.ssm.model.ListInventoryEntriesRequest.ReadOnly = new Wrapper(impl)
}
