package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInventorySchemaResponse(
    schemas: Optional[Iterable[zio.aws.ssm.model.InventoryItemSchema]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse = {
    import GetInventorySchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse
      .builder()
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemas)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly =
    zio.aws.ssm.model.GetInventorySchemaResponse.wrap(buildAwsValue())
}
object GetInventorySchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetInventorySchemaResponse =
      zio.aws.ssm.model.GetInventorySchemaResponse(
        schemas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def schemas: Optional[List[zio.aws.ssm.model.InventoryItemSchema.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSchemas: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryItemSchema.ReadOnly
    ]] = AwsError.unwrapOptionField("schemas", schemas)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse
  ) extends zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly {
    override val schemas
        : Optional[List[zio.aws.ssm.model.InventoryItemSchema.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryItemSchema.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse
  ): zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly = new Wrapper(impl)
}
