package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, PatchBaselineMaxResults}
import scala.jdk.CollectionConverters._
final case class DescribePatchBaselinesRequest(
    filters: Optional[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] =
      Optional.Absent,
    maxResults: Optional[PatchBaselineMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest = {
    import DescribePatchBaselinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => PatchBaselineMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchBaselinesRequest.ReadOnly =
    zio.aws.ssm.model.DescribePatchBaselinesRequest.wrap(buildAwsValue())
}
object DescribePatchBaselinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchBaselinesRequest =
      zio.aws.ssm.model.DescribePatchBaselinesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def maxResults: Optional[PatchBaselineMaxResults]
    def nextToken: Optional[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, PatchBaselineMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
  ) extends zio.aws.ssm.model.DescribePatchBaselinesRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[PatchBaselineMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchBaselineMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
  ): zio.aws.ssm.model.DescribePatchBaselinesRequest.ReadOnly = new Wrapper(
    impl
  )
}
