package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  Comment,
  DocumentName,
  Url,
  InstanceId,
  CommandId,
  DocumentVersion,
  DateTime,
  InvocationTraceOutput,
  ServiceRole,
  InstanceTagName,
  StatusDetails
}
import scala.jdk.CollectionConverters._
final case class CommandInvocation(
    commandId: Optional[CommandId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    instanceName: Optional[InstanceTagName] = Optional.Absent,
    comment: Optional[Comment] = Optional.Absent,
    documentName: Optional[DocumentName] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    requestedDateTime: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.CommandInvocationStatus] =
      Optional.Absent,
    statusDetails: Optional[StatusDetails] = Optional.Absent,
    traceOutput: Optional[InvocationTraceOutput] = Optional.Absent,
    standardOutputUrl: Optional[Url] = Optional.Absent,
    standardErrorUrl: Optional[Url] = Optional.Absent,
    commandPlugins: Optional[Iterable[zio.aws.ssm.model.CommandPlugin]] =
      Optional.Absent,
    serviceRole: Optional[ServiceRole] = Optional.Absent,
    notificationConfig: Optional[zio.aws.ssm.model.NotificationConfig] =
      Optional.Absent,
    cloudWatchOutputConfig: Optional[zio.aws.ssm.model.CloudWatchOutputConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CommandInvocation = {
    import CommandInvocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CommandInvocation
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        instanceName.map(value =>
          InstanceTagName.unwrap(value): java.lang.String
        )
      )(_.instanceName)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        requestedDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.requestedDateTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        traceOutput.map(value =>
          InvocationTraceOutput.unwrap(value): java.lang.String
        )
      )(_.traceOutput)
      .optionallyWith(
        standardOutputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardOutputUrl)
      .optionallyWith(
        standardErrorUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardErrorUrl)
      .optionallyWith(
        commandPlugins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commandPlugins)
      .optionallyWith(
        serviceRole.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CommandInvocation.ReadOnly =
    zio.aws.ssm.model.CommandInvocation.wrap(buildAwsValue())
}
object CommandInvocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CommandInvocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CommandInvocation =
      zio.aws.ssm.model.CommandInvocation(
        commandId.map(value => value),
        instanceId.map(value => value),
        instanceName.map(value => value),
        comment.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        requestedDateTime.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        traceOutput.map(value => value),
        standardOutputUrl.map(value => value),
        standardErrorUrl.map(value => value),
        commandPlugins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRole.map(value => value),
        notificationConfig.map(value => value.asEditable),
        cloudWatchOutputConfig.map(value => value.asEditable)
      )
    def commandId: Optional[CommandId]
    def instanceId: Optional[InstanceId]
    def instanceName: Optional[InstanceTagName]
    def comment: Optional[Comment]
    def documentName: Optional[DocumentName]
    def documentVersion: Optional[DocumentVersion]
    def requestedDateTime: Optional[DateTime]
    def status: Optional[zio.aws.ssm.model.CommandInvocationStatus]
    def statusDetails: Optional[StatusDetails]
    def traceOutput: Optional[InvocationTraceOutput]
    def standardOutputUrl: Optional[Url]
    def standardErrorUrl: Optional[Url]
    def commandPlugins: Optional[List[zio.aws.ssm.model.CommandPlugin.ReadOnly]]
    def serviceRole: Optional[ServiceRole]
    def notificationConfig
        : Optional[zio.aws.ssm.model.NotificationConfig.ReadOnly]
    def cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceName: ZIO[Any, AwsError, InstanceTagName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getRequestedDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("requestedDateTime", requestedDateTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.CommandInvocationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getTraceOutput: ZIO[Any, AwsError, InvocationTraceOutput] =
      AwsError.unwrapOptionField("traceOutput", traceOutput)
    def getStandardOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardOutputUrl", standardOutputUrl)
    def getStandardErrorUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardErrorUrl", standardErrorUrl)
    def getCommandPlugins
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.CommandPlugin.ReadOnly]] =
      AwsError.unwrapOptionField("commandPlugins", commandPlugins)
    def getServiceRole: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getNotificationConfig
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CommandInvocation
  ) extends zio.aws.ssm.model.CommandInvocation.ReadOnly {
    override val commandId: Optional[CommandId] = zio.aws.core.internal
      .optionalFromNullable(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val instanceName: Optional[InstanceTagName] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceName())
      .map(value => zio.aws.ssm.model.primitives.InstanceTagName(value))
    override val comment: Optional[Comment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val documentName: Optional[DocumentName] = zio.aws.core.internal
      .optionalFromNullable(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val requestedDateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.ssm.model.CommandInvocationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.CommandInvocationStatus.wrap(value))
    override val statusDetails: Optional[StatusDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val traceOutput: Optional[InvocationTraceOutput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.traceOutput())
        .map(value => zio.aws.ssm.model.primitives.InvocationTraceOutput(value))
    override val standardOutputUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.standardOutputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val standardErrorUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.standardErrorUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val commandPlugins
        : Optional[List[zio.aws.ssm.model.CommandPlugin.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commandPlugins())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.CommandPlugin.wrap(item)
          }.toList
        )
    override val serviceRole: Optional[ServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val notificationConfig
        : Optional[zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationConfig())
        .map(value => zio.aws.ssm.model.NotificationConfig.wrap(value))
    override val cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchOutputConfig())
        .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CommandInvocation
  ): zio.aws.ssm.model.CommandInvocation.ReadOnly = new Wrapper(impl)
}
