package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait AutomationExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus
}
object AutomationExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus
  ): zio.aws.ssm.model.AutomationExecutionStatus = value match {
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.WAITING =>
      val r = Waiting
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CANCELLING =>
      val r = Cancelling
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.PENDING_APPROVAL =>
      val r = PendingApproval
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.APPROVED =>
      val r = Approved
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.REJECTED =>
      val r = Rejected
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.SCHEDULED =>
      val r = Scheduled
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.RUNBOOK_IN_PROGRESS =>
      val r = RunbookInProgress
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.PENDING_CHANGE_CALENDAR_OVERRIDE =>
      val r = PendingChangeCalendarOverride
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CHANGE_CALENDAR_OVERRIDE_APPROVED =>
      val r = ChangeCalendarOverrideApproved
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CHANGE_CALENDAR_OVERRIDE_REJECTED =>
      val r = ChangeCalendarOverrideRejected
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.COMPLETED_WITH_SUCCESS =>
      val r = CompletedWithSuccess
      r
    case software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.COMPLETED_WITH_FAILURE =>
      val r = CompletedWithFailure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.PENDING
  }
  case object InProgress extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.IN_PROGRESS
  }
  case object Waiting extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.WAITING
  }
  case object Success extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.SUCCESS
  }
  case object TimedOut extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.TIMED_OUT
  }
  case object Cancelling extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CANCELLING
  }
  case object Cancelled extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CANCELLED
  }
  case object Failed extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.FAILED
  }
  case object PendingApproval
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.PENDING_APPROVAL
  }
  case object Approved extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.APPROVED
  }
  case object Rejected extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.REJECTED
  }
  case object Scheduled extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.SCHEDULED
  }
  case object RunbookInProgress
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.RUNBOOK_IN_PROGRESS
  }
  case object PendingChangeCalendarOverride
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.PENDING_CHANGE_CALENDAR_OVERRIDE
  }
  case object ChangeCalendarOverrideApproved
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CHANGE_CALENDAR_OVERRIDE_APPROVED
  }
  case object ChangeCalendarOverrideRejected
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.CHANGE_CALENDAR_OVERRIDE_REJECTED
  }
  case object CompletedWithSuccess
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.COMPLETED_WITH_SUCCESS
  }
  case object CompletedWithFailure
      extends zio.aws.ssm.model.AutomationExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus =
      software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus.COMPLETED_WITH_FAILURE
  }
}
