package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AssociationFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociationFilter(
    key: zio.aws.ssm.model.AssociationFilterKey,
    value: AssociationFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationFilter = {
    import AssociationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationFilter
      .builder()
      .key(key.unwrap)
      .value(AssociationFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationFilter.ReadOnly =
    zio.aws.ssm.model.AssociationFilter.wrap(buildAwsValue())
}
object AssociationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationFilter =
      zio.aws.ssm.model.AssociationFilter(key, value)
    def key: zio.aws.ssm.model.AssociationFilterKey
    def value: AssociationFilterValue
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.AssociationFilterKey] =
      ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, AssociationFilterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationFilter
  ) extends zio.aws.ssm.model.AssociationFilter.ReadOnly {
    override val key: zio.aws.ssm.model.AssociationFilterKey =
      zio.aws.ssm.model.AssociationFilterKey.wrap(impl.key())
    override val value: AssociationFilterValue =
      zio.aws.ssm.model.primitives.AssociationFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationFilter
  ): zio.aws.ssm.model.AssociationFilter.ReadOnly = new Wrapper(impl)
}
