package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  DateTime,
  OpsItemType,
  OpsItemPriority,
  OpsItemSource,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemDescription,
  OpsItemTitle,
  OpsItemArn,
  OpsItemCategory
}
import scala.jdk.CollectionConverters._
final case class OpsItem(
    createdBy: Optional[String] = Optional.Absent,
    opsItemType: Optional[OpsItemType] = Optional.Absent,
    createdTime: Optional[DateTime] = Optional.Absent,
    description: Optional[OpsItemDescription] = Optional.Absent,
    lastModifiedBy: Optional[String] = Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent,
    notifications: Optional[Iterable[zio.aws.ssm.model.OpsItemNotification]] =
      Optional.Absent,
    priority: Optional[OpsItemPriority] = Optional.Absent,
    relatedOpsItems: Optional[Iterable[zio.aws.ssm.model.RelatedOpsItem]] =
      Optional.Absent,
    status: Optional[zio.aws.ssm.model.OpsItemStatus] = Optional.Absent,
    opsItemId: Optional[OpsItemId] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    title: Optional[OpsItemTitle] = Optional.Absent,
    source: Optional[OpsItemSource] = Optional.Absent,
    operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = Optional.Absent,
    category: Optional[OpsItemCategory] = Optional.Absent,
    severity: Optional[OpsItemSeverity] = Optional.Absent,
    actualStartTime: Optional[DateTime] = Optional.Absent,
    actualEndTime: Optional[DateTime] = Optional.Absent,
    plannedStartTime: Optional[DateTime] = Optional.Absent,
    plannedEndTime: Optional[DateTime] = Optional.Absent,
    opsItemArn: Optional[OpsItemArn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.OpsItem = {
    import OpsItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItem
      .builder()
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        opsItemType.map(value => OpsItemType.unwrap(value): java.lang.String)
      )(_.opsItemType)
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        description.map(value =>
          OpsItemDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        relatedOpsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedOpsItems)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        title.map(value => OpsItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        source.map(value => OpsItemSource.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .optionallyWith(
        opsItemArn.map(value => OpsItemArn.unwrap(value): java.lang.String)
      )(_.opsItemArn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItem.ReadOnly =
    zio.aws.ssm.model.OpsItem.wrap(buildAwsValue())
}
object OpsItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItem = zio.aws.ssm.model.OpsItem(
      createdBy.map(value => value),
      opsItemType.map(value => value),
      createdTime.map(value => value),
      description.map(value => value),
      lastModifiedBy.map(value => value),
      lastModifiedTime.map(value => value),
      notifications.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      priority.map(value => value),
      relatedOpsItems.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      status.map(value => value),
      opsItemId.map(value => value),
      version.map(value => value),
      title.map(value => value),
      source.map(value => value),
      operationalData.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      ),
      category.map(value => value),
      severity.map(value => value),
      actualStartTime.map(value => value),
      actualEndTime.map(value => value),
      plannedStartTime.map(value => value),
      plannedEndTime.map(value => value),
      opsItemArn.map(value => value)
    )
    def createdBy: Optional[String]
    def opsItemType: Optional[OpsItemType]
    def createdTime: Optional[DateTime]
    def description: Optional[OpsItemDescription]
    def lastModifiedBy: Optional[String]
    def lastModifiedTime: Optional[DateTime]
    def notifications
        : Optional[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]]
    def priority: Optional[OpsItemPriority]
    def relatedOpsItems
        : Optional[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]]
    def status: Optional[zio.aws.ssm.model.OpsItemStatus]
    def opsItemId: Optional[OpsItemId]
    def version: Optional[String]
    def title: Optional[OpsItemTitle]
    def source: Optional[OpsItemSource]
    def operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def category: Optional[OpsItemCategory]
    def severity: Optional[OpsItemSeverity]
    def actualStartTime: Optional[DateTime]
    def actualEndTime: Optional[DateTime]
    def plannedStartTime: Optional[DateTime]
    def plannedEndTime: Optional[DateTime]
    def opsItemArn: Optional[OpsItemArn]
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getOpsItemType: ZIO[Any, AwsError, OpsItemType] =
      AwsError.unwrapOptionField("opsItemType", opsItemType)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDescription: ZIO[Any, AwsError, OpsItemDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemNotification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRelatedOpsItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      AwsError.unwrapOptionField("relatedOpsItems", relatedOpsItems)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getTitle: ZIO[Any, AwsError, OpsItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getSource: ZIO[Any, AwsError, OpsItemSource] =
      AwsError.unwrapOptionField("source", source)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
    def getOpsItemArn: ZIO[Any, AwsError, OpsItemArn] =
      AwsError.unwrapOptionField("opsItemArn", opsItemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItem
  ) extends zio.aws.ssm.model.OpsItem.ReadOnly {
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val opsItemType: Optional[OpsItemType] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemType())
      .map(value => zio.aws.ssm.model.primitives.OpsItemType(value))
    override val createdTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val description: Optional[OpsItemDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.OpsItemDescription(value))
    override val lastModifiedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: String)
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val notifications
        : Optional[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemNotification.wrap(item)
          }.toList
        )
    override val priority: Optional[OpsItemPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val relatedOpsItems
        : Optional[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedOpsItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.RelatedOpsItem.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.ssm.model.OpsItemStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.OpsItemStatus.wrap(value))
    override val opsItemId: Optional[OpsItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val title: Optional[OpsItemTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.ssm.model.primitives.OpsItemTitle(value))
    override val source: Optional[OpsItemSource] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSource(value))
    override val operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val category: Optional[OpsItemCategory] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Optional[OpsItemSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val actualStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val opsItemArn: Optional[OpsItemArn] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemArn())
      .map(value => zio.aws.ssm.model.primitives.OpsItemArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItem
  ): zio.aws.ssm.model.OpsItem.ReadOnly = new Wrapper(impl)
}
