package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentARN,
  DocumentVersion,
  DateTime,
  DocumentSchemaVersion,
  DocumentAuthor,
  DocumentOwner,
  DocumentVersionName,
  TargetType
}
import scala.jdk.CollectionConverters._
final case class DocumentIdentifier(
    name: Optional[DocumentARN] = Optional.Absent,
    createdDate: Optional[DateTime] = Optional.Absent,
    displayName: Optional[DocumentDisplayName] = Optional.Absent,
    owner: Optional[DocumentOwner] = Optional.Absent,
    versionName: Optional[DocumentVersionName] = Optional.Absent,
    platformTypes: Optional[Iterable[zio.aws.ssm.model.PlatformType]] =
      Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    documentType: Optional[zio.aws.ssm.model.DocumentType] = Optional.Absent,
    schemaVersion: Optional[DocumentSchemaVersion] = Optional.Absent,
    documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      Optional.Absent,
    targetType: Optional[TargetType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent,
    requires: Optional[Iterable[zio.aws.ssm.model.DocumentRequires]] =
      Optional.Absent,
    reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus] = Optional.Absent,
    author: Optional[DocumentAuthor] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentIdentifier = {
    import DocumentIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentIdentifier
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        owner.map(value => DocumentOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        platformTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformTypesWithStrings)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(
        schemaVersion.map(value =>
          DocumentSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.schemaVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .optionallyWith(
        author.map(value => DocumentAuthor.unwrap(value): java.lang.String)
      )(_.author)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentIdentifier.ReadOnly =
    zio.aws.ssm.model.DocumentIdentifier.wrap(buildAwsValue())
}
object DocumentIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentIdentifier =
      zio.aws.ssm.model.DocumentIdentifier(
        name.map(value => value),
        createdDate.map(value => value),
        displayName.map(value => value),
        owner.map(value => value),
        versionName.map(value => value),
        platformTypes.map(value => value),
        documentVersion.map(value => value),
        documentType.map(value => value),
        schemaVersion.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reviewStatus.map(value => value),
        author.map(value => value)
      )
    def name: Optional[DocumentARN]
    def createdDate: Optional[DateTime]
    def displayName: Optional[DocumentDisplayName]
    def owner: Optional[DocumentOwner]
    def versionName: Optional[DocumentVersionName]
    def platformTypes: Optional[List[zio.aws.ssm.model.PlatformType]]
    def documentVersion: Optional[DocumentVersion]
    def documentType: Optional[zio.aws.ssm.model.DocumentType]
    def schemaVersion: Optional[DocumentSchemaVersion]
    def documentFormat: Optional[zio.aws.ssm.model.DocumentFormat]
    def targetType: Optional[TargetType]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def requires: Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus]
    def author: Optional[DocumentAuthor]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getOwner: ZIO[Any, AwsError, DocumentOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getPlatformTypes
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PlatformType]] =
      AwsError.unwrapOptionField("platformTypes", platformTypes)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getSchemaVersion: ZIO[Any, AwsError, DocumentSchemaVersion] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
    def getAuthor: ZIO[Any, AwsError, DocumentAuthor] =
      AwsError.unwrapOptionField("author", author)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentIdentifier
  ) extends zio.aws.ssm.model.DocumentIdentifier.ReadOnly {
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val createdDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val displayName: Optional[DocumentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val owner: Optional[DocumentOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.ssm.model.primitives.DocumentOwner(value))
    override val versionName: Optional[DocumentVersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionName())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val platformTypes: Optional[List[zio.aws.ssm.model.PlatformType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PlatformType.wrap(item)
          }.toList
        )
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentType: Optional[zio.aws.ssm.model.DocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentType())
        .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val schemaVersion: Optional[DocumentSchemaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentSchemaVersion(value))
    override val documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Optional[TargetType] = zio.aws.core.internal
      .optionalFromNullable(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
    override val requires
        : Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requires())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentRequires.wrap(item)
          }.toList
        )
    override val reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reviewStatus())
        .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val author: Optional[DocumentAuthor] = zio.aws.core.internal
      .optionalFromNullable(impl.author())
      .map(value => zio.aws.ssm.model.primitives.DocumentAuthor(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentIdentifier
  ): zio.aws.ssm.model.DocumentIdentifier.ReadOnly = new Wrapper(impl)
}
