package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AlarmName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AlarmStateInformation(
    name: AlarmName,
    state: zio.aws.ssm.model.ExternalAlarmState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AlarmStateInformation = {
    import AlarmStateInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AlarmStateInformation
      .builder()
      .name(AlarmName.unwrap(name): java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AlarmStateInformation.ReadOnly =
    zio.aws.ssm.model.AlarmStateInformation.wrap(buildAwsValue())
}
object AlarmStateInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AlarmStateInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AlarmStateInformation =
      zio.aws.ssm.model.AlarmStateInformation(name, state)
    def name: AlarmName
    def state: zio.aws.ssm.model.ExternalAlarmState
    def getName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(name)
    def getState: ZIO[Any, Nothing, zio.aws.ssm.model.ExternalAlarmState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AlarmStateInformation
  ) extends zio.aws.ssm.model.AlarmStateInformation.ReadOnly {
    override val name: AlarmName =
      zio.aws.ssm.model.primitives.AlarmName(impl.name())
    override val state: zio.aws.ssm.model.ExternalAlarmState =
      zio.aws.ssm.model.ExternalAlarmState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AlarmStateInformation
  ): zio.aws.ssm.model.AlarmStateInformation.ReadOnly = new Wrapper(impl)
}
