package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.StepExecutionFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StepExecutionFilter(
    key: zio.aws.ssm.model.StepExecutionFilterKey,
    values: Iterable[StepExecutionFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StepExecutionFilter = {
    import StepExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StepExecutionFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        StepExecutionFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StepExecutionFilter.ReadOnly =
    zio.aws.ssm.model.StepExecutionFilter.wrap(buildAwsValue())
}
object StepExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StepExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StepExecutionFilter =
      zio.aws.ssm.model.StepExecutionFilter(key, values)
    def key: zio.aws.ssm.model.StepExecutionFilterKey
    def values: List[StepExecutionFilterValue]
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.StepExecutionFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[StepExecutionFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StepExecutionFilter
  ) extends zio.aws.ssm.model.StepExecutionFilter.ReadOnly {
    override val key: zio.aws.ssm.model.StepExecutionFilterKey =
      zio.aws.ssm.model.StepExecutionFilterKey.wrap(impl.key())
    override val values: List[StepExecutionFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.StepExecutionFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StepExecutionFilter
  ): zio.aws.ssm.model.StepExecutionFilter.ReadOnly = new Wrapper(impl)
}
