package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ServiceSettingId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetServiceSettingRequest(settingId: ServiceSettingId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest = {
    import ResetServiceSettingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest
      .builder()
      .settingId(ServiceSettingId.unwrap(settingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResetServiceSettingRequest.ReadOnly =
    zio.aws.ssm.model.ResetServiceSettingRequest.wrap(buildAwsValue())
}
object ResetServiceSettingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResetServiceSettingRequest =
      zio.aws.ssm.model.ResetServiceSettingRequest(settingId)
    def settingId: ServiceSettingId
    def getSettingId: ZIO[Any, Nothing, ServiceSettingId] =
      ZIO.succeed(settingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest
  ) extends zio.aws.ssm.model.ResetServiceSettingRequest.ReadOnly {
    override val settingId: ServiceSettingId =
      zio.aws.ssm.model.primitives.ServiceSettingId(impl.settingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest
  ): zio.aws.ssm.model.ResetServiceSettingRequest.ReadOnly = new Wrapper(impl)
}
