package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  CommandMaxResults,
  InstanceId,
  CommandId
}
import scala.jdk.CollectionConverters._
final case class ListCommandInvocationsRequest(
    commandId: Optional[CommandId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    maxResults: Optional[CommandMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.CommandFilter]] =
      Optional.Absent,
    details: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest = {
    import ListCommandInvocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        maxResults.map(value => CommandMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(details.map(value => value: java.lang.Boolean))(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListCommandInvocationsRequest.ReadOnly =
    zio.aws.ssm.model.ListCommandInvocationsRequest.wrap(buildAwsValue())
}
object ListCommandInvocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListCommandInvocationsRequest =
      zio.aws.ssm.model.ListCommandInvocationsRequest(
        commandId.map(value => value),
        instanceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        details.map(value => value)
      )
    def commandId: Optional[CommandId]
    def instanceId: Optional[InstanceId]
    def maxResults: Optional[CommandMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ssm.model.CommandFilter.ReadOnly]]
    def details: Optional[Boolean]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getMaxResults: ZIO[Any, AwsError, CommandMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.CommandFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDetails: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
  ) extends zio.aws.ssm.model.ListCommandInvocationsRequest.ReadOnly {
    override val commandId: Optional[CommandId] = zio.aws.core.internal
      .optionalFromNullable(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val maxResults: Optional[CommandMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.CommandMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val filters
        : Optional[List[zio.aws.ssm.model.CommandFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.CommandFilter.wrap(item)
          }.toList
        )
    override val details: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
  ): zio.aws.ssm.model.ListCommandInvocationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
