package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{Policy, PolicyHash, PolicyId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourcePoliciesResponseEntry(
    policyId: Optional[PolicyId] = Optional.Absent,
    policyHash: Optional[PolicyHash] = Optional.Absent,
    policy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry = {
    import GetResourcePoliciesResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry
      .builder()
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyHash.map(value => PolicyHash.unwrap(value): java.lang.String)
      )(_.policyHash)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly =
    zio.aws.ssm.model.GetResourcePoliciesResponseEntry.wrap(buildAwsValue())
}
object GetResourcePoliciesResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetResourcePoliciesResponseEntry =
      zio.aws.ssm.model.GetResourcePoliciesResponseEntry(
        policyId.map(value => value),
        policyHash.map(value => value),
        policy.map(value => value)
      )
    def policyId: Optional[PolicyId]
    def policyHash: Optional[PolicyHash]
    def policy: Optional[Policy]
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyHash: ZIO[Any, AwsError, PolicyHash] =
      AwsError.unwrapOptionField("policyHash", policyHash)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry
  ) extends zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly {
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.ssm.model.primitives.PolicyId(value))
    override val policyHash: Optional[PolicyHash] = zio.aws.core.internal
      .optionalFromNullable(impl.policyHash())
      .map(value => zio.aws.ssm.model.primitives.PolicyHash(value))
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.ssm.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry
  ): zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly = new Wrapper(
    impl
  )
}
