package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  EffectiveInstanceAssociationMaxResults,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class DescribeEffectiveInstanceAssociationsRequest(
    instanceId: InstanceId,
    maxResults: Optional[EffectiveInstanceAssociationMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest = {
    import DescribeEffectiveInstanceAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          EffectiveInstanceAssociationMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeEffectiveInstanceAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest =
      zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest(
        instanceId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def maxResults: Optional[EffectiveInstanceAssociationMaxResults]
    def nextToken: Optional[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getMaxResults
        : ZIO[Any, AwsError, EffectiveInstanceAssociationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ) extends zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val maxResults: Optional[EffectiveInstanceAssociationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives
            .EffectiveInstanceAssociationMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ): zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
