package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  DateTime,
  OpsMetadataArn,
  OpsMetadataResourceId
}
import scala.jdk.CollectionConverters._
final case class OpsMetadata(
    resourceId: Optional[OpsMetadataResourceId] = Optional.Absent,
    opsMetadataArn: Optional[OpsMetadataArn] = Optional.Absent,
    lastModifiedDate: Optional[DateTime] = Optional.Absent,
    lastModifiedUser: Optional[String] = Optional.Absent,
    creationDate: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.OpsMetadata = {
    import OpsMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsMetadata
      .builder()
      .optionallyWith(
        resourceId.map(value =>
          OpsMetadataResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        opsMetadataArn.map(value =>
          OpsMetadataArn.unwrap(value): java.lang.String
        )
      )(_.opsMetadataArn)
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedUser.map(value => value: java.lang.String))(
        _.lastModifiedUser
      )
      .optionallyWith(
        creationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsMetadata.ReadOnly =
    zio.aws.ssm.model.OpsMetadata.wrap(buildAwsValue())
}
object OpsMetadata {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsMetadata] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsMetadata =
      zio.aws.ssm.model.OpsMetadata(
        resourceId.map(value => value),
        opsMetadataArn.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedUser.map(value => value),
        creationDate.map(value => value)
      )
    def resourceId: Optional[OpsMetadataResourceId]
    def opsMetadataArn: Optional[OpsMetadataArn]
    def lastModifiedDate: Optional[DateTime]
    def lastModifiedUser: Optional[String]
    def creationDate: Optional[DateTime]
    def getResourceId: ZIO[Any, AwsError, OpsMetadataResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getOpsMetadataArn: ZIO[Any, AwsError, OpsMetadataArn] =
      AwsError.unwrapOptionField("opsMetadataArn", opsMetadataArn)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
    def getCreationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsMetadata
  ) extends zio.aws.ssm.model.OpsMetadata.ReadOnly {
    override val resourceId: Optional[OpsMetadataResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value => zio.aws.ssm.model.primitives.OpsMetadataResourceId(value))
    override val opsMetadataArn: Optional[OpsMetadataArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsMetadataArn())
        .map(value => zio.aws.ssm.model.primitives.OpsMetadataArn(value))
    override val lastModifiedDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedUser())
      .map(value => value: String)
    override val creationDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsMetadata
  ): zio.aws.ssm.model.OpsMetadata.ReadOnly = new Wrapper(impl)
}
