package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  PatchComplianceMaxResults,
  NextToken,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class DescribeInstancePatchesRequest(
    instanceId: InstanceId,
    filters: Optional[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[PatchComplianceMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest = {
    import DescribeInstancePatchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          PatchComplianceMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeInstancePatchesRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePatchesRequest.wrap(buildAwsValue())
}
object DescribeInstancePatchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstancePatchesRequest =
      zio.aws.ssm.model.DescribeInstancePatchesRequest(
        instanceId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[PatchComplianceMaxResults]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PatchComplianceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest
  ) extends zio.aws.ssm.model.DescribeInstancePatchesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[PatchComplianceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchComplianceMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest
  ): zio.aws.ssm.model.DescribeInstancePatchesRequest.ReadOnly = new Wrapper(
    impl
  )
}
