package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  StatusAdditionalInfo,
  StatusMessage,
  DateTime
}
import scala.jdk.CollectionConverters._
final case class AssociationStatus(
    date: DateTime,
    name: zio.aws.ssm.model.AssociationStatusName,
    message: StatusMessage,
    additionalInfo: Optional[StatusAdditionalInfo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationStatus = {
    import AssociationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationStatus
      .builder()
      .date(DateTime.unwrap(date): Instant)
      .name(name.unwrap)
      .message(StatusMessage.unwrap(message): java.lang.String)
      .optionallyWith(
        additionalInfo.map(value =>
          StatusAdditionalInfo.unwrap(value): java.lang.String
        )
      )(_.additionalInfo)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationStatus.ReadOnly =
    zio.aws.ssm.model.AssociationStatus.wrap(buildAwsValue())
}
object AssociationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationStatus =
      zio.aws.ssm.model.AssociationStatus(
        date,
        name,
        message,
        additionalInfo.map(value => value)
      )
    def date: DateTime
    def name: zio.aws.ssm.model.AssociationStatusName
    def message: StatusMessage
    def additionalInfo: Optional[StatusAdditionalInfo]
    def getDate: ZIO[Any, Nothing, DateTime] = ZIO.succeed(date)
    def getName: ZIO[Any, Nothing, zio.aws.ssm.model.AssociationStatusName] =
      ZIO.succeed(name)
    def getMessage: ZIO[Any, Nothing, StatusMessage] = ZIO.succeed(message)
    def getAdditionalInfo: ZIO[Any, AwsError, StatusAdditionalInfo] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationStatus
  ) extends zio.aws.ssm.model.AssociationStatus.ReadOnly {
    override val date: DateTime =
      zio.aws.ssm.model.primitives.DateTime(impl.date())
    override val name: zio.aws.ssm.model.AssociationStatusName =
      zio.aws.ssm.model.AssociationStatusName.wrap(impl.name())
    override val message: StatusMessage =
      zio.aws.ssm.model.primitives.StatusMessage(impl.message())
    override val additionalInfo: Optional[StatusAdditionalInfo] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalInfo())
        .map(value => zio.aws.ssm.model.primitives.StatusAdditionalInfo(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationStatus
  ): zio.aws.ssm.model.AssociationStatus.ReadOnly = new Wrapper(impl)
}
