package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class PatchStatus(
    deploymentStatus: Optional[zio.aws.ssm.model.PatchDeploymentStatus] =
      Optional.Absent,
    complianceLevel: Optional[zio.aws.ssm.model.PatchComplianceLevel] =
      Optional.Absent,
    approvalDate: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.PatchStatus = {
    import PatchStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchStatus
      .builder()
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(complianceLevel.map(value => value.unwrap))(
        _.complianceLevel
      )
      .optionallyWith(
        approvalDate.map(value => DateTime.unwrap(value): Instant)
      )(_.approvalDate)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchStatus.ReadOnly =
    zio.aws.ssm.model.PatchStatus.wrap(buildAwsValue())
}
object PatchStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.PatchStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchStatus =
      zio.aws.ssm.model.PatchStatus(
        deploymentStatus.map(value => value),
        complianceLevel.map(value => value),
        approvalDate.map(value => value)
      )
    def deploymentStatus: Optional[zio.aws.ssm.model.PatchDeploymentStatus]
    def complianceLevel: Optional[zio.aws.ssm.model.PatchComplianceLevel]
    def approvalDate: Optional[DateTime]
    def getDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchDeploymentStatus] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField("complianceLevel", complianceLevel)
    def getApprovalDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("approvalDate", approvalDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchStatus
  ) extends zio.aws.ssm.model.PatchStatus.ReadOnly {
    override val deploymentStatus
        : Optional[zio.aws.ssm.model.PatchDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatus())
        .map(value => zio.aws.ssm.model.PatchDeploymentStatus.wrap(value))
    override val complianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceLevel())
        .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approvalDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchStatus
  ): zio.aws.ssm.model.PatchStatus.ReadOnly = new Wrapper(impl)
}
