package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, MaxResults, PSParameterName}
import scala.jdk.CollectionConverters._
final case class GetParameterHistoryRequest(
    name: PSParameterName,
    withDecryption: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest = {
    import GetParameterHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .optionallyWith(withDecryption.map(value => value: java.lang.Boolean))(
        _.withDecryption
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParameterHistoryRequest.ReadOnly =
    zio.aws.ssm.model.GetParameterHistoryRequest.wrap(buildAwsValue())
}
object GetParameterHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParameterHistoryRequest =
      zio.aws.ssm.model.GetParameterHistoryRequest(
        name,
        withDecryption.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: PSParameterName
    def withDecryption: Optional[Boolean]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
    def getWithDecryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withDecryption", withDecryption)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
  ) extends zio.aws.ssm.model.GetParameterHistoryRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
    override val withDecryption: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.withDecryption())
      .map(value => value: Boolean)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest
  ): zio.aws.ssm.model.GetParameterHistoryRequest.ReadOnly = new Wrapper(impl)
}
