package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{ResourceDataSyncType, ResourceDataSyncName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteResourceDataSyncRequest(
    syncName: ResourceDataSyncName,
    syncType: Optional[ResourceDataSyncType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest = {
    import DeleteResourceDataSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest
      .builder()
      .syncName(ResourceDataSyncName.unwrap(syncName): java.lang.String)
      .optionallyWith(
        syncType.map(value =>
          ResourceDataSyncType.unwrap(value): java.lang.String
        )
      )(_.syncType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteResourceDataSyncRequest.ReadOnly =
    zio.aws.ssm.model.DeleteResourceDataSyncRequest.wrap(buildAwsValue())
}
object DeleteResourceDataSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteResourceDataSyncRequest =
      zio.aws.ssm.model
        .DeleteResourceDataSyncRequest(syncName, syncType.map(value => value))
    def syncName: ResourceDataSyncName
    def syncType: Optional[ResourceDataSyncType]
    def getSyncName: ZIO[Any, Nothing, ResourceDataSyncName] =
      ZIO.succeed(syncName)
    def getSyncType: ZIO[Any, AwsError, ResourceDataSyncType] =
      AwsError.unwrapOptionField("syncType", syncType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest
  ) extends zio.aws.ssm.model.DeleteResourceDataSyncRequest.ReadOnly {
    override val syncName: ResourceDataSyncName =
      zio.aws.ssm.model.primitives.ResourceDataSyncName(impl.syncName())
    override val syncType: Optional[ResourceDataSyncType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncType())
        .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest
  ): zio.aws.ssm.model.DeleteResourceDataSyncRequest.ReadOnly = new Wrapper(
    impl
  )
}
