package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PatchGroup
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePatchGroupStateRequest(patchGroup: PatchGroup) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest = {
    import DescribePatchGroupStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest
      .builder()
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchGroupStateRequest.ReadOnly =
    zio.aws.ssm.model.DescribePatchGroupStateRequest.wrap(buildAwsValue())
}
object DescribePatchGroupStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchGroupStateRequest =
      zio.aws.ssm.model.DescribePatchGroupStateRequest(patchGroup)
    def patchGroup: PatchGroup
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest
  ) extends zio.aws.ssm.model.DescribePatchGroupStateRequest.ReadOnly {
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest
  ): zio.aws.ssm.model.DescribePatchGroupStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
