package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait AttachmentHashType {
  def unwrap: software.amazon.awssdk.services.ssm.model.AttachmentHashType
}
object AttachmentHashType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AttachmentHashType
  ): zio.aws.ssm.model.AttachmentHashType = value match {
    case software.amazon.awssdk.services.ssm.model.AttachmentHashType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AttachmentHashType.SHA256 =>
      val r = Sha256
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.AttachmentHashType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AttachmentHashType =
      software.amazon.awssdk.services.ssm.model.AttachmentHashType.UNKNOWN_TO_SDK_VERSION
  }
  case object Sha256 extends zio.aws.ssm.model.AttachmentHashType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AttachmentHashType =
      software.amazon.awssdk.services.ssm.model.AttachmentHashType.SHA256
  }
}
